<?php
/**
 * WCMD Options Framework Setup
 *
 * @package WP Mailchip Discount
 * @version 3.1.4
 */
! defined( 'ABSPATH' ) AND exit;


/**
* Loads the required Options Framework classes
*
* @since 3.5
* @param empty
* @return empty
*
*/
if ( is_admin() && ! function_exists( 'wcmd_optionsframework_init' ) ) :

function wcmd_optionsframework_init() {

	//  If user can't edit theme options, exit
	if ( ! current_user_can( 'edit_theme_options' ) )
		return;

	require WCMD_PATH . 'options-framework/class-options-framework.php';
	require WCMD_PATH . 'options-framework/class-options-framework-admin.php';
	require WCMD_PATH . 'options-framework/class-options-interface.php';
	require WCMD_PATH . 'options-framework/class-options-media-uploader.php';
	require WCMD_PATH . 'options-framework/class-options-sanitization.php';

	// Instantiate the main plugin class.
	$options_framework = new Wcmd_Options_Framework;
	$options_framework->init();

	// Instantiate the options page.
	$Wcmd_Options_Framework_Admin = new Wcmd_Options_Framework_Admin;
	$Wcmd_Options_Framework_Admin->init();

	// Instantiate the media uploader class
	$options_framework_media_uploader = new Wcmd_Options_Framework_Media_Uploader;
	$options_framework_media_uploader->init();
}
add_action( 'init', 'wcmd_optionsframework_init', 20 );

endif;


/**
 * Helper function to return the theme option value.
 * If no value has been saved, it returns $default.
 * Needed because options are saved as serialized strings.
 *
 * Not in a class to support backwards compatibility in themes.
 */

if ( ! function_exists( 'wcmd_of_get_option' ) ) :

function wcmd_of_get_option( $name, $default = false ) {
	$config = get_option( 'wcmd_optionsframework' );

	if ( ! isset( $config['id'] ) ) {
		return $default;
	}

	$options = get_option( $config['id'] );

	if ( isset( $options[$name] ) ) {
		return $options[$name];
	}

	return $default;
}

endif;